// collision
var _xx = lengthdir_x(speed, direction); 
var _yy = lengthdir_y(speed, direction); 

// collision with wall
if (place_meeting(x + _xx, y + _yy, oWall)) {

	move_bounce_all(false); 
	audio_play_sound(sndBounce, 2, false); 
	
} 

// collision with breakable
var _breakable = instance_place(x + _xx, y + _yy, oBreakable); 

if (_breakable != noone) {

	if (!_breakable.hit) {
		move_bounce_all(false); 
		_breakable.hit = true; 
		audio_play_sound(sndBounce, 2, false); 
	}
	
}

// collision with player & critter

var _player = instance_place(x, y, oCowboy); 

if (_player != noone) {

	if (_player.shotBuffer <= 0) {
		audio_play_sound(sndHitBad, 2, false); 
		_player.hit = true; 
		oGameState.failed = true; 
		instance_destroy(); 	
	}
	
}

if (place_meeting(x, y, oCritter)) {

	audio_play_sound(sndHitBad, 2, false); 
	instance_destroy(); 	
	
}


// sprite handling
image_angle = direction; 

// keep face in correct orientation
if (direction >= 90 && direction <= 270) image_yscale = -1; 
else image_yscale = 1; 

depth = -y; 